   /**
    *
    *   Universite catholique de Louvain
    *   CEREM : Centre for research in mechatronics
    *   http://www.robotran.be  
    *   Contact : info@robotran.be
    *
    *
    *   MBsysC main script template for simple model:
    *   -----------------------------------------------
    *    This template loads the data file *.mbs and execute:
    *      - the coordinate partitioning module
    *      - the direct dynamic module (time integration of
    *        equations of motion).
    *    It may be adapted and completed by the user.
    * 
    *    (c) Universite catholique de Louvain
    *
    * To turn this file as a C++ file, just change its extension to .cc (or .cpp).
    * If you plan to use some C++ files, it is usually better that the main is compiled as a C++ function.
    * Currently, most compilers do not require this, but it is a safer approach to port your code to other computers.
    */

#include <stdio.h>
#include "mbs_set.h"
#include "mbs_data.h"
#include "mbs_part.h"
#include "realtime.h"
#include "mbs_equil.h"
#include "mbs_modal.h"
#include "mbs_dirdyn.h"
#include "user_model.h"
#include "user_all_id.h"
#include "mbs_loader.h"
#include "mbs_solvekin.h"
#include <mbs_solvekin_struct.h>
//#include "mbs_kinematic.h"

int main(int argc, char const *argv[])
{
    printf("Starting five_point_suspension_c MBS project!\n");

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*                     LOADING                               *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
    MbsData *mbs_data;
    
    printf("Loading the five_point_suspension_c data file !\n");
    mbs_data = mbs_load("five_point_suspension_c.mbs");
    printf("*.mbs file loaded!\n");

	
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*              COORDINATE PARTITIONING                      *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
    MbsPart *mbs_part;
    mbs_data->process = 1;
    
    mbs_part = mbs_new_part(mbs_data);
    
    mbs_part->options->rowperm=1;
    mbs_part->options->verbose = 1;
    mbs_run_part(mbs_part, mbs_data);
    
    mbs_delete_part(mbs_part);

	mbs_data->q0[1] = 0.278; // 0.3;

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*                    EQUILIBRIUM                            *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
    MbsEquil *mbs_equil;
    mbs_data->process = 2;
    
    mbs_equil = mbs_new_equil(mbs_data);

	//mbs_set_qa(mbs_data, T3_chassis_id);
    // Equil options (see documentations for additional options)
    mbs_equil->options->method  = 1;
    mbs_equil->options->senstol = 1e-6;
    mbs_equil->options->verbose = 1;

    // Variable addition, xe: neutral lenght of the spring
    // mbs_equil->options->nxe = 1;
    // mbs_equil_addition(mbs_equil->options);
    // mbs_equil->options->xe_ptr[1] = &(mbs_data->user_model->Spring.l0);
    // Additionnal equilibrium equation, in user_equil.c: vertical position of the wheel
	
	mbs_data->q[1] = 0.278; // 0.3;
    mbs_equil->options->nquch = 1; // nquch = nxch
    mbs_equil_exchange(mbs_equil->options);
    mbs_equil->options->quch[1] = R1_chassis_barre2_id;
    mbs_equil->options->xch_ptr[1] = &(mbs_data->user_model->SUSP.z0);
	mbs_equil->options->save2file = 1;
	mbs_equil->options->resfilename = "equil";

    mbs_run_equil(mbs_equil, mbs_data);

	printf("Spring neutral length at equilibrium : %f\n", mbs_data->user_model->SUSP.z0);
	printf("Chassis eight at equilibrium : %f", mbs_data->q[T3_chassis_id]);
    mbs_delete_equil(mbs_equil, mbs_data);
	

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*                   MODAL ANALYSIS                          *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
    /* MbsModal *mbs_modal;
    mbs_data->process = 4;

    mbs_modal = mbs_new_modal(mbs_data); */
    // modal options (see documentations for additional options)
    /* mbs_modal->options->save_result = 1;
    mbs_modal->options->save_anim = 1;
    mbs_modal->options->mode_ampl=0.2;
    mbs_modal->options->verbose = 1;
    mbs_run_modal(mbs_modal, mbs_data);
    mbs_delete_modal(mbs_modal, mbs_data); */
	
	
	mbs_data->process = 50;
	mbs_set_qdriven(mbs_data, R1_chassis_barre2_id);
	MbsSolvekin* mbs_solvekin = mbs_new_solvekin(mbs_data);
	// Set the motion to be solved as a trajectory
	mbs_solvekin->options->motion = 2; // (motion = "trajectory");
	// Provide the time interval and time step to solve the inverse kinematics.
	mbs_solvekin->options->t0 = 0.0;
	mbs_solvekin->options->tf = 1.0;
	mbs_solvekin->options->dt = 1e-3;
	mbs_run_solvekin(mbs_solvekin, mbs_data);
	mbs_delete_solvekin(mbs_solvekin, mbs_data);
	
	// Second kinematics to get the suspension kinematics from lower bumpstop to upper bumpstop
	MbsDirdyn *mbs_dirdyn;
	mbs_data->process = 51;
	mbs_dirdyn = mbs_new_dirdyn(mbs_data);

	// Provide the time interval and time step to solve the inverse kinematics.
	mbs_dirdyn->options->t0 = 0.0;
	mbs_dirdyn->options->tf = 1.0;
	mbs_dirdyn->options->dt0 = 1e-3;
	mbs_run_dirdyn(mbs_dirdyn, mbs_data);
	mbs_delete_dirdyn(mbs_dirdyn, mbs_data);

	mbs_data->process = 30;
	mbs_set_qu(mbs_data, R1_chassis_barre2_id);
	copy_dvec_1(mbs_data->q0, mbs_data->q);
	mbs_dirdyn = mbs_new_dirdyn(mbs_data);
	mbs_dirdyn->options->dt0 = 1e-3;
	mbs_dirdyn->options->tf = 1;
	mbs_dirdyn->options->save2file = 1;
	mbs_dirdyn->options->resfilename = "dirdyn";
	mbs_run_dirdyn(mbs_dirdyn, mbs_data);
	mbs_delete_dirdyn(mbs_dirdyn, mbs_data);

	mbs_data->process = 31;
	copy_dvec_1(mbs_data->q0, mbs_data->q);
	mbs_dirdyn = mbs_new_dirdyn(mbs_data);
	mbs_dirdyn->options->dt0 = 1e-3;
	mbs_dirdyn->options->tf = 20;
	mbs_dirdyn->options->save2file = 1;
	mbs_dirdyn->options->resfilename = "sweep";
	mbs_run_dirdyn(mbs_dirdyn, mbs_data);
	mbs_delete_dirdyn(mbs_dirdyn, mbs_data);
 

    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    /*                   CLOSING OPERATIONS                      *
    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
    mbs_delete_data(mbs_data);
    
    return 0;
}

